//=============================================================================
// RPGツクールMZ - ShowLogWindow.js
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc 戦闘画面に特定のログを表示します。
 * @author emoriiin979
 *
 * @help ShowLogWindow.js
 *
 * 戦闘ログの表示・クリアのコマンドを提供します。
 *
 * @command showLog
 * @text ログ表示
 * @desc ログを表示します。
 *
 * @arg logMessage
 * @text ログメッセージ
 * @desc 表示するログメッセージを入力します。
 * @type string
 *
 * @command clearLog
 * @text ログ消去
 * @desc ログをクリアします。
 */

(() => {
    "use strict";

    const pluginName = "ShowLogWindow";

    //=========================================================================
    // プラグインコマンド
    //=========================================================================

    // ログ表示
    PluginManager.registerCommand(pluginName, "showLog", args => {
        BattleManager._logWindow.addText(args["logMessage"]);
    });

    // ログ消去
    PluginManager.registerCommand(pluginName, "clearLog", args => {
        BattleManager._logWindow.clear();
    });
})();
